<?php
header('Content-Type: application/json');
require_once 'config.php';

// Get raw JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Check required parameters
if (!isset($input['email']) || !isset($input['new_password'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required parameters'
    ]);
    exit;
}

$email = $input['email'];
$new_password = $input['new_password'];

// Validate email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid email format'
    ]);
    exit;
}

// Update password as plain text
$stmt = $conn->prepare("UPDATE loginusers SET password = ? WHERE email = ?");
if (!$stmt) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Prepare statement failed: ' . $conn->error
    ]);
    exit;
}

$stmt->bind_param("ss", $new_password, $email);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Password updated successfully'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'No user found with this email'
    ]);
}

$stmt->close();
$conn->close();
?>
